function sp = rmusic_1d(R, n, k, mv, varargin)
%Root MUSIC for ULAs.
%Reference:
%   [1] H. L. Van Trees, Optimum array processing. New York: Wiley, 2002.
unit = 'radian';
for ii = 1:2:nargin-4
    option_name = varargin{ii};
    option_value = varargin{ii+1};
    switch lower(option_name)
        case 'unit'
            unit = option_value;
        otherwise
            error('Unknow option ''%s''.', option_name);
    end
end
m = size(R, 1);

if n >= m
    error('Too many sources.');
end

% root MUSIC
[E, l] = eig(R, 'vector');
if isreal(l)
    En = E(:,1:end-n);
else
    [~, idx] = sort(abs(l));
    En = E(:,idx(1:end-n));
end

  derad = pi/180;
  twpi = 2*pi;
  for iang = 1:361*5
        angle(iang)=(iang-181)/2;
        phim=derad*angle(iang);
        m_v = (mv-1)/2;
        d = 0:0.5:m_v;
        a=exp(-j*twpi*d*sin(phim)).';
        %L=iwave;    
        %En=EV(:,L+1:kelm);
        SP(iang)=(a'*a)/(a'*En*En'*a);
  end
   
% 
SP=abs(SP);


C = En*En';
coeff = zeros(m - 1, 1);
for ii = 1:m-1
    coeff(ii) = sum(diag(C, ii));
end
coeff = [flipud(coeff); sum(diag(C)); conj(coeff)];
% solve
z = roots(coeff)'; % roots returns a column vector
% find n points inside the unit circle that are also closest to the unit
% circle
nz = length(z);
mask = true(nz, 1);
for ii = 1:nz
    absz = abs(z(ii));
    if absz > 1
        mask(ii) = false;
    elseif absz == 1
        % find the closest point and remove it
        idx = -1;
        dist = inf;
        for jj = 1:nz
            if jj ~= ii && mask(jj)
                cur_dist = abs(z(ii) - z(jj));
                if cur_dist < dist
                    dist = cur_dist;
                    idx = jj;
                end
            end
        end
        mask(idx) = false;
    end
end
z = z(mask);
[~, idx] = sort(1 - abs(z));
%}

sp = struct();
sp.x_est = sort(-cm2doa(z(idx(1:n)), k, unit));
sp.x = sp.x_est;
sp.x_unit = unit;
%sp.y = ones(1, n);
sp.y = SP;
sp.theta = angle;
sp.resolved = true;
sp.discrete = true;
end

function doa = cm2doa(z, k, unit)
%CM2DOA Converts complex exponentials to doas.
switch lower(unit)
    case 'radian'
        doa = asin(angle(z) / k);
    case 'degree'
        doa = rad2deg(asin(angle(z) / k));
    case 'sin'
        doa = angle(z) / k;
    otherwise
        error('Unkown unit ''%s''.', unit);
end
end

